<?php
require_once __DIR__ . '/functions.php';

// If already logged in redirect to dashboard
if (isLoggedIn()) {
    redirect('dashboard.php');
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    if (loginUser($pdo, $email, $password)) {
        redirect('dashboard.php');
    } else {
        $error = "Identifiants invalides. Veuillez réessayer.";
    }
}

$pageTitle = 'Connexion';
include 'header.php';
?>

<h2>Connexion</h2>

<?php if ($error): ?>
    <div class="message error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>

<form method="post" action="">
    <label for="email">Adresse email</label>
    <input type="email" id="email" name="email" required>

    <label for="password">Mot de passe</label>
    <input type="password" id="password" name="password" required>

    <button type="submit">Se connecter</button>
</form>

<p>Pas de compte ? <a href="register.php">Inscrivez-vous ici</a>.</p>

<?php
include 'footer.php';
?>