<?php
// This file outputs the top portion of the HTML layout.  It expects
// that the session has already been started and that functions.php
// has been included if you want to use currentUser().  It includes
// a simple navigation bar and links to the stylesheet and scripts.

// Determine the page title, or fall back to a default
$pageTitle = isset($pageTitle) ? $pageTitle : 'EPS Application';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle); ?></title>
    <!-- Bootstrap CSS via CDN for responsive design -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" integrity="sha384-TvKrd1Aovlpbcyq7syjxMNFM8Ii57RTIRJfz0rCV6mEfJkRgcjkjLgRM8UkPDn8H" crossorigin="anonymous">
    <!-- Bootstrap Icons for simple vector icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <!-- DataTables CSS for interactive tables (uses Bootstrap 5 styling) -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <!-- Custom stylesheet to override Bootstrap if needed -->
    <link rel="stylesheet" href="style.css">
    <!-- Manifest for PWA installation -->
    <link rel="manifest" href="manifest.json">
</head>
<body class="d-flex flex-column min-vh-100">
    <!-- Navigation bar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container-fluid">
            <a class="navbar-brand" href="dashboard.php">EPS</a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <?php if (isLoggedIn()): ?>
                        <?php $roles = getUserRoles($pdo, $_SESSION['user_id']); ?>
                        <!-- Teacher navigation -->
                        <?php if (in_array('teacher', $roles)): ?>
                            <li class="nav-item"><a class="nav-link" href="dashboard.php">Tableau de bord</a></li>
                            <li class="nav-item"><a class="nav-link" href="create_class.php">Nouvelle classe</a></li>
                        <?php endif; ?>
                        <!-- Coordinator navigation -->
                        <?php if (in_array('coordinator', $roles)): ?>
                            <li class="nav-item"><a class="nav-link" href="dashboard.php">Coordination</a></li>
                        <?php endif; ?>
                        <!-- Principal navigation -->
                        <?php if (in_array('principal', $roles)): ?>
                            <li class="nav-item"><a class="nav-link" href="dashboard.php">Établissement</a></li>
                        <?php endif; ?>
                        <!-- Inspector navigation -->
                        <?php if (in_array('inspector', $roles)): ?>
                            <li class="nav-item"><a class="nav-link" href="dashboard.php">Inspection</a></li>
                        <?php endif; ?>
                        <!-- Common resources -->
                        <?php if (in_array('teacher', $roles) || in_array('coordinator', $roles)): ?>
                            <li class="nav-item"><a class="nav-link" href="oe_library.php">Bibliothèque OE</a></li>
                            <li class="nav-item"><a class="nav-link" href="fps_library.php">Bibliothèque FPS</a></li>
                        <?php endif; ?>
                        <!-- Reports accessible to teachers and coordination roles -->
                        <?php if (in_array('teacher', $roles) || in_array('coordinator', $roles) || in_array('principal', $roles)): ?>
                            <li class="nav-item"><a class="nav-link" href="reports.php">Rapports</a></li>
                        <?php endif; ?>
                        <li class="nav-item"><a class="nav-link" href="logout.php">Déconnexion</a></li>
                    <?php else: ?>
                        <li class="nav-item"><a class="nav-link" href="login.php">Connexion</a></li>
                        <li class="nav-item"><a class="nav-link" href="register.php">Créer un compte</a></li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>
    <main class="flex-fill container py-3">