<?php
/**
 * FICHIER DE VÉRIFICATION DE CONNEXION
 * Placez ce fichier dans votre répertoire web et accédez-y directement
 */

// Configuration de la base de données
$db_host = 'localhost';
$db_name = 'epsweb_appli';
$db_user = 'epsweb_appli';
$db_pass = 'MF03444janvierA';

try {
    $pdo = new PDO(
        "mysql:host=$db_host;dbname=$db_name;charset=utf8mb4",
        $db_user,
        $db_pass
    );
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "✅ Connexion à la base de données réussie<br><br>";
} catch (PDOException $e) {
    die('❌ Erreur de connexion à la base : ' . $e->getMessage());
}

// TEST 1: Vérifier si le compte demo@demo.com existe
echo "<h2>TEST 1: Vérification du compte demo@demo.com</h2>";
$stmt = $pdo->prepare('SELECT * FROM users WHERE email = ?');
$stmt->execute(['demo@demo.com']);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user) {
    echo "✅ Le compte existe<br>";
    echo "ID: " . $user['id'] . "<br>";
    echo "Nom: " . $user['name'] . "<br>";
    echo "Email: " . $user['email'] . "<br>";
    echo "Role: " . $user['role'] . "<br>";
    echo "Hash dans la base: <code>" . $user['password'] . "</code><br><br>";
} else {
    echo "❌ Le compte demo@demo.com n'existe pas !<br>";
    echo "Création du compte...<br>";
    
    // Créer le compte
    $hash = password_hash('test123', PASSWORD_DEFAULT);
    $stmt = $pdo->prepare('INSERT INTO users (name, email, password, role) VALUES (?, ?, ?, ?)');
    $stmt->execute(['Compte Démo', 'demo@demo.com', $hash, 'teacher']);
    echo "✅ Compte créé avec succès<br><br>";
    
    // Recharger les données
    $stmt = $pdo->prepare('SELECT * FROM users WHERE email = ?');
    $stmt->execute(['demo@demo.com']);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
}

// TEST 2: Vérifier le mot de passe
echo "<h2>TEST 2: Vérification du mot de passe</h2>";
$passwords_to_test = ['test123', 'Demo123!', 'password', 'demo123', 'Demo123'];

foreach ($passwords_to_test as $pwd) {
    if (password_verify($pwd, $user['password'])) {
        echo "✅ <strong>Le mot de passe '$pwd' FONCTIONNE !</strong><br>";
    } else {
        echo "❌ '$pwd' ne fonctionne pas<br>";
    }
}

// TEST 3: Forcer la mise à jour du mot de passe
echo "<h2>TEST 3: Mise à jour forcée du mot de passe</h2>";
$new_hash = password_hash('test123', PASSWORD_DEFAULT);
$stmt = $pdo->prepare('UPDATE users SET password = ? WHERE email = ?');
$stmt->execute([$new_hash, 'demo@demo.com']);
echo "✅ Mot de passe mis à jour avec 'test123'<br>";
echo "Nouveau hash: <code>$new_hash</code><br><br>";

// TEST 4: Vérifier les classes
echo "<h2>TEST 4: Vérification des classes</h2>";
$stmt = $pdo->prepare('SELECT COUNT(*) as total FROM classes WHERE teacher_id = ?');
$stmt->execute([$user['id']]);
$result = $stmt->fetch(PDO::FETCH_ASSOC);
echo "Nombre de classes pour ce compte: " . $result['total'] . "<br>";

if ($result['total'] == 0) {
    echo "❌ Aucune classe trouvée<br>";
    echo "Création de classes de test...<br>";
    
    // Créer des classes
    $stmt = $pdo->prepare('INSERT INTO classes (name, level, teacher_id) VALUES (?, ?, ?)');
    $classes = [
        ['2bidonA', 'Seconde professionnelle'],
        ['1bidonA', 'Première professionnelle'],
        ['1bidonB', 'Première professionnelle'],
        ['6ème A', '6ème'],
        ['5ème B', '5ème']
    ];
    
    foreach ($classes as $class) {
        try {
            $stmt->execute([$class[0], $class[1], $user['id']]);
            echo "✅ Classe '{$class[0]}' créée<br>";
        } catch (Exception $e) {
            echo "⚠️ Classe '{$class[0]}' existe peut-être déjà<br>";
        }
    }
} else {
    echo "✅ Des classes existent<br>";
    
    // Lister les classes
    $stmt = $pdo->prepare('SELECT name, level FROM classes WHERE teacher_id = ? ORDER BY name');
    $stmt->execute([$user['id']]);
    echo "<h3>Liste des classes:</h3>";
    while ($class = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "- " . $class['name'] . " (" . $class['level'] . ")<br>";
    }
}

// TEST 5: Test de connexion simulé
echo "<h2>TEST 5: Simulation de connexion</h2>";
$email = 'demo@demo.com';
$password = 'test123';

$stmt = $pdo->prepare('SELECT * FROM users WHERE email = ?');
$stmt->execute([$email]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user && password_verify($password, $user['password'])) {
    echo "✅ <strong>CONNEXION RÉUSSIE avec demo@demo.com / test123</strong><br>";
} else {
    echo "❌ Échec de connexion<br>";
}

// RÉSUMÉ FINAL
echo "<h2 style='background: #4CAF50; color: white; padding: 10px;'>RÉSUMÉ</h2>";
echo "<div style='background: #f0f0f0; padding: 15px; border-left: 4px solid #4CAF50;'>";
echo "<strong>Identifiants de connexion:</strong><br>";
echo "Email: <strong>demo@demo.com</strong><br>";
echo "Mot de passe: <strong>test123</strong><br><br>";
echo "Si la connexion ne fonctionne toujours pas sur login.php, vérifiez :<br>";
echo "1. Que vous utilisez bien ces identifiants exacts<br>";
echo "2. Qu'il n'y a pas d'espaces avant/après l'email ou le mot de passe<br>";
echo "3. Que les sessions PHP sont activées sur votre serveur<br>";
echo "4. Que le fichier config.php utilise les bonnes informations de base de données<br>";
echo "</div>";

// Afficher tous les utilisateurs
echo "<h2>TOUS LES UTILISATEURS DANS LA BASE</h2>";
$stmt = $pdo->query('SELECT id, name, email, role FROM users');
echo "<table border='1' style='border-collapse: collapse;'>";
echo "<tr><th>ID</th><th>Nom</th><th>Email</th><th>Rôle</th><th>Mot de passe de test</th></tr>";
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    echo "<tr>";
    echo "<td>{$row['id']}</td>";
    echo "<td>{$row['name']}</td>";
    echo "<td>{$row['email']}</td>";
    echo "<td>{$row['role']}</td>";
    echo "<td>test123</td>";
    echo "</tr>";
}
echo "</table>";

?>

<style>
body {
    font-family: Arial, sans-serif;
    max-width: 1000px;
    margin: 50px auto;
    padding: 20px;
}
h2 {
    color: #333;
    border-bottom: 2px solid #4CAF50;
    padding-bottom: 10px;
}
code {
    background: #f0f0f0;
    padding: 2px 5px;
    font-size: 12px;
}
table {
    width: 100%;
    margin-top: 10px;
}
th {
    background: #4CAF50;
    color: white;
    padding: 8px;
}
td {
    padding: 8px;
}
</style>
