<?php
require_once __DIR__ . '/functions.php';

// Only logged-in users with the role teacher or coordinator can create a class
if (!isLoggedIn()) {
    redirect('login.php');
}
// Check for appropriate role
if (!userHasRole($pdo, 'teacher') && !userHasRole($pdo, 'coordinator')) {
    // Unauthorized users are redirected to the dashboard
    redirect('dashboard.php');
}

$user = currentUser($pdo);
$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $level = trim($_POST['level'] ?? '');
    if (!$name) {
        $error = "Le nom de la classe est requis.";
    } else {
        // Insert the class with current user as the main teacher for backward compatibility
        $stmt = $pdo->prepare('INSERT INTO classes (name, level, teacher_id) VALUES (?, ?, ?)');
        $pdo->beginTransaction();
        if ($stmt->execute([$name, $level, $user['id']])) {
            $classId = $pdo->lastInsertId();
            // Insert mapping into class_teachers if table exists
            $tables = $pdo->query("SHOW TABLES LIKE 'class_teachers'")->fetchAll(PDO::FETCH_ASSOC);
            if ($tables) {
                $stmtMap = $pdo->prepare('INSERT INTO class_teachers (class_id, user_id) VALUES (?, ?)');
                $stmtMap->execute([$classId, $user['id']]);
            }
            $pdo->commit();
            $success = "Classe créée avec succès.";
        } else {
            $pdo->rollBack();
            $error = "Une erreur est survenue lors de la création de la classe.";
        }
    }
}

$pageTitle = 'Créer une classe';
include 'header.php';
?>

<h2>Créer une nouvelle classe</h2>

<?php if ($error): ?>
    <div class="message error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>
<?php if ($success): ?>
    <div class="message success"><?php echo htmlspecialchars($success); ?></div>
<?php endif; ?>

<form method="post" action="">
    <label for="name">Nom de la classe</label>
    <input type="text" id="name" name="name" required>

    <label for="level">Niveau (facultatif)</label>
    <input type="text" id="level" name="level">

    <button type="submit">Créer la classe</button>
</form>

<?php
include 'footer.php';
?>