<?php
require_once __DIR__ . '/functions.php';

// If user not logged in, redirect to login page
if (!isLoggedIn()) {
    redirect('login.php');
}

$user = currentUser($pdo);
$classes = getTeacherClasses($pdo, $user['id']);

$pageTitle = 'Tableau de bord';
include 'header.php';
?>

<div class="mt-4">
    <h2 class="mb-3">Bonjour, <?php echo htmlspecialchars($user['name']); ?> !</h2>
    <p class="mb-4">Utilisez ce tableau de bord pour gérer vos classes, cycles et leçons.</p>

    <?php if (empty($classes)): ?>
        <div class="alert alert-info">Aucune classe n'a encore été créée. <a href="create_class.php" class="alert-link">Ajoutez une première classe</a>.</div>
    <?php else: ?>
        <h3>Vos classes</h3>
        <div class="table-responsive">
            <table class="table table-striped align-middle datatable">
                <thead class="table-primary">
                    <tr>
                        <th>Nom de la classe</th>
                        <th>Niveau</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($classes as $class): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($class['name']); ?></td>
                        <td><?php echo htmlspecialchars($class['level']); ?></td>
                        <td>
                            <a href="class_detail.php?id=<?php echo $class['id']; ?>" class="btn btn-sm btn-outline-primary">Voir</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>

<?php
include 'footer.php';
?>