<?php
/**
 * VÉRIFICATION COMPLÈTE DES CYCLES ET LEÇONS
 */

// Configuration de la base de données
$db_host = 'localhost';
$db_name = 'epsweb_appli';
$db_user = 'epsweb_appli';
$db_pass = 'MF03444janvierA';

try {
    $pdo = new PDO("mysql:host=$db_host;dbname=$db_name;charset=utf8mb4", $db_user, $db_pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die('❌ Erreur de connexion : ' . $e->getMessage());
}

// Récupérer l'ID du compte demo
$stmt = $pdo->prepare('SELECT id FROM users WHERE email = ?');
$stmt->execute(['demo@demo.com']);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
$demo_id = $user['id'];

echo "<h1>Vérification complète des données pour demo@demo.com</h1>";

// RÉSUMÉ GLOBAL
echo "<h2 style='background: #2196F3; color: white; padding: 10px;'>RÉSUMÉ GLOBAL</h2>";

// Compter tout
$sql = "
    SELECT 
        (SELECT COUNT(*) FROM classes WHERE teacher_id = ?) AS classes,
        (SELECT COUNT(*) FROM cycles c JOIN classes cl ON c.class_id = cl.id WHERE cl.teacher_id = ?) AS cycles,
        (SELECT COUNT(*) FROM lessons l JOIN cycles c ON l.cycle_id = c.id JOIN classes cl ON c.class_id = cl.id WHERE cl.teacher_id = ?) AS lecons,
        (SELECT COUNT(*) FROM students s JOIN classes cl ON s.class_id = cl.id WHERE cl.teacher_id = ?) AS eleves
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$demo_id, $demo_id, $demo_id, $demo_id]);
$stats = $stmt->fetch(PDO::FETCH_ASSOC);

echo "<table border='1' style='width: 100%; border-collapse: collapse;'>";
echo "<tr>";
echo "<th style='background: #4CAF50; color: white; padding: 10px;'>Classes</th>";
echo "<th style='background: #4CAF50; color: white; padding: 10px;'>Cycles</th>";
echo "<th style='background: #4CAF50; color: white; padding: 10px;'>Leçons</th>";
echo "<th style='background: #4CAF50; color: white; padding: 10px;'>Élèves</th>";
echo "</tr>";
echo "<tr style='text-align: center; font-size: 24px; font-weight: bold;'>";
echo "<td style='padding: 15px;'>" . $stats['classes'] . "</td>";
echo "<td style='padding: 15px; " . ($stats['cycles'] >= 15 ? "color: green;" : "color: red;") . "'>" . $stats['cycles'] . " / 15</td>";
echo "<td style='padding: 15px; " . ($stats['lecons'] >= 120 ? "color: green;" : "color: red;") . "'>" . $stats['lecons'] . " / 120</td>";
echo "<td style='padding: 15px;'>" . $stats['eleves'] . "</td>";
echo "</tr>";
echo "</table>";

// DÉTAIL PAR CLASSE
echo "<h2 style='background: #FF9800; color: white; padding: 10px; margin-top: 30px;'>DÉTAIL PAR CLASSE</h2>";

$sql = "
    SELECT 
        cl.id,
        cl.name,
        cl.level,
        COUNT(DISTINCT cy.id) AS nb_cycles,
        COUNT(DISTINCT l.id) AS nb_lecons,
        COUNT(DISTINCT s.id) AS nb_eleves
    FROM classes cl
    LEFT JOIN cycles cy ON cy.class_id = cl.id
    LEFT JOIN lessons l ON l.cycle_id = cy.id
    LEFT JOIN students s ON s.class_id = cl.id
    WHERE cl.teacher_id = ?
    GROUP BY cl.id
    ORDER BY cl.name
";
$stmt = $pdo->prepare($sql);
$stmt->execute([$demo_id]);

echo "<table border='1' style='width: 100%; border-collapse: collapse;'>";
echo "<tr>";
echo "<th style='background: #555; color: white; padding: 8px;'>Classe</th>";
echo "<th style='background: #555; color: white; padding: 8px;'>Niveau</th>";
echo "<th style='background: #555; color: white; padding: 8px;'>Cycles</th>";
echo "<th style='background: #555; color: white; padding: 8px;'>Leçons</th>";
echo "<th style='background: #555; color: white; padding: 8px;'>Élèves</th>";
echo "</tr>";

while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $expected_cycles = in_array($row['name'], ['2bidonA', '1bidonA', '1bidonB']) ? 5 : 0;
    $expected_lecons = $expected_cycles * 8;
    
    echo "<tr>";
    echo "<td style='padding: 8px; font-weight: bold;'>" . $row['name'] . "</td>";
    echo "<td style='padding: 8px;'>" . $row['level'] . "</td>";
    echo "<td style='padding: 8px; text-align: center; " . ($expected_cycles > 0 && $row['nb_cycles'] < $expected_cycles ? "color: red;" : "") . "'>";
    echo $row['nb_cycles'];
    if ($expected_cycles > 0) echo " / " . $expected_cycles;
    echo "</td>";
    echo "<td style='padding: 8px; text-align: center; " . ($expected_lecons > 0 && $row['nb_lecons'] < $expected_lecons ? "color: red;" : "") . "'>";
    echo $row['nb_lecons'];
    if ($expected_lecons > 0) echo " / " . $expected_lecons;
    echo "</td>";
    echo "<td style='padding: 8px; text-align: center;'>" . $row['nb_eleves'] . "</td>";
    echo "</tr>";
}
echo "</table>";

// DÉTAIL DES CYCLES PAR CLASSE PRO
$classes_pro = ['2bidonA', '1bidonA', '1bidonB'];

foreach ($classes_pro as $classe_name) {
    echo "<h3 style='background: #673AB7; color: white; padding: 10px; margin-top: 30px;'>Cycles pour $classe_name</h3>";
    
    // Récupérer l'ID de la classe
    $stmt = $pdo->prepare('SELECT id FROM classes WHERE name = ? AND teacher_id = ?');
    $stmt->execute([$classe_name, $demo_id]);
    $classe = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($classe) {
        $sql = "
            SELECT 
                cy.name AS cycle_name,
                cy.ppsad AS activite,
                cy.activity,
                COUNT(l.id) AS nb_lecons,
                cy.start_date,
                cy.end_date
            FROM cycles cy
            LEFT JOIN lessons l ON l.cycle_id = cy.id
            WHERE cy.class_id = ?
            GROUP BY cy.id
            ORDER BY cy.name
        ";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$classe['id']]);
        
        $cycles = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        if (count($cycles) > 0) {
            echo "<table border='1' style='width: 100%; border-collapse: collapse; margin-bottom: 20px;'>";
            echo "<tr>";
            echo "<th style='background: #9C27B0; color: white; padding: 8px;'>Cycle</th>";
            echo "<th style='background: #9C27B0; color: white; padding: 8px;'>Activité</th>";
            echo "<th style='background: #9C27B0; color: white; padding: 8px;'>Nb Leçons</th>";
            echo "<th style='background: #9C27B0; color: white; padding: 8px;'>Période</th>";
            echo "</tr>";
            
            foreach ($cycles as $cycle) {
                $activite = $cycle['ppsad'] ?: $cycle['activity'];
                echo "<tr>";
                echo "<td style='padding: 8px;'>" . $cycle['cycle_name'] . "</td>";
                echo "<td style='padding: 8px;'>" . $activite . "</td>";
                echo "<td style='padding: 8px; text-align: center; " . ($cycle['nb_lecons'] < 8 ? "color: red;" : "color: green;") . "'>" . $cycle['nb_lecons'] . " / 8</td>";
                echo "<td style='padding: 8px;'>" . $cycle['start_date'] . " → " . $cycle['end_date'] . "</td>";
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<p style='color: red; font-weight: bold;'>❌ Aucun cycle trouvé pour cette classe !</p>";
        }
    } else {
        echo "<p style='color: red;'>Classe non trouvée</p>";
    }
}

// DIAGNOSTIC FINAL
echo "<h2 style='background: #F44336; color: white; padding: 10px; margin-top: 30px;'>DIAGNOSTIC</h2>";

if ($stats['cycles'] >= 15 && $stats['lecons'] >= 120) {
    echo "<div style='background: #4CAF50; color: white; padding: 15px; font-size: 18px;'>";
    echo "✅ <strong>TOUT EST OK !</strong><br>";
    echo "Vous avez bien les 15 cycles et les 120 leçons.<br>";
    echo "Vous pouvez vous connecter avec demo@demo.com / test123";
    echo "</div>";
} elseif ($stats['cycles'] > 0) {
    echo "<div style='background: #FF9800; color: white; padding: 15px;'>";
    echo "⚠️ <strong>DONNÉES PARTIELLES</strong><br>";
    echo "Il manque des cycles ou des leçons.<br>";
    echo "Vous avez : " . $stats['cycles'] . " cycles sur 15 et " . $stats['lecons'] . " leçons sur 120.<br>";
    echo "<br><strong>ACTION :</strong> Importez le fichier <code>epsweb_appli_FINAL_part2_CORRIGE.sql</code>";
    echo "</div>";
} else {
    echo "<div style='background: #F44336; color: white; padding: 15px;'>";
    echo "❌ <strong>CYCLES ET LEÇONS MANQUANTS</strong><br>";
    echo "Les cycles et leçons n'ont pas été importés.<br>";
    echo "<br><strong>ACTION URGENTE :</strong><br>";
    echo "1. Dans phpMyAdmin, sélectionnez la base 'epsweb_appli'<br>";
    echo "2. Importez le fichier <code>epsweb_appli_FINAL_part2_CORRIGE.sql</code><br>";
    echo "3. Revenez sur cette page pour vérifier";
    echo "</div>";
}

// CE QUI DEVRAIT ÊTRE PRÉSENT
echo "<h2 style='background: #3F51B5; color: white; padding: 10px; margin-top: 30px;'>CE QUI DEVRAIT ÊTRE PRÉSENT</h2>";
echo "<div style='background: #E3F2FD; padding: 15px; border-left: 4px solid #3F51B5;'>";
echo "<strong>Pour chaque classe professionnelle (2bidonA, 1bidonA, 1bidonB) :</strong><br>";
echo "• <strong>CED</strong> (Course de durée) : 1 cycle avec 8 leçons<br>";
echo "• <strong>VB</strong> (Volley-ball) : 1 cycle avec 8 leçons<br>";
echo "• <strong>MUSC</strong> (Musculation) : 1 cycle avec 8 leçons<br>";
echo "• <strong>TT</strong> (Tennis de table) : 1 cycle avec 8 leçons<br>";
echo "• <strong>ACRO</strong> (Acrosport) : 1 cycle avec 8 leçons<br>";
echo "<br><strong>Total :</strong> 5 cycles × 3 classes = 15 cycles<br>";
echo "<strong>Total :</strong> 8 leçons × 15 cycles = 120 leçons";
echo "</div>";

?>

<style>
body {
    font-family: Arial, sans-serif;
    max-width: 1200px;
    margin: 30px auto;
    padding: 20px;
    background: #f5f5f5;
}
h1 {
    color: #333;
    text-align: center;
    border-bottom: 3px solid #4CAF50;
    padding-bottom: 20px;
}
table {
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}
code {
    background: #333;
    color: #fff;
    padding: 2px 6px;
    border-radius: 3px;
}
</style>
