-- ========================================================
-- INSTALLATION SCRIPT FOR VERSION 2 OF THE EPS APPLICATION
--
-- This script extends the original schema with new tables and
-- relationships to support multiple teachers per class,
-- advanced user roles, and student login capabilities.
-- It should be executed after running the original install.sql.
--
-- Note: adjust database name if necessary.
-- ========================================================

USE epsweb_appli;

-- Insert additional roles into the roles table (ignore if they already exist)
INSERT INTO roles (name)
SELECT * FROM (SELECT 'coordinator' AS name) AS tmp
WHERE NOT EXISTS (SELECT 1 FROM roles WHERE name = 'coordinator');

INSERT INTO roles (name)
SELECT * FROM (SELECT 'principal' AS name) AS tmp
WHERE NOT EXISTS (SELECT 1 FROM roles WHERE name = 'principal');

INSERT INTO roles (name)
SELECT * FROM (SELECT 'inspector' AS name) AS tmp
WHERE NOT EXISTS (SELECT 1 FROM roles WHERE name = 'inspector');

INSERT INTO roles (name)
SELECT * FROM (SELECT 'student' AS name) AS tmp
WHERE NOT EXISTS (SELECT 1 FROM roles WHERE name = 'student');

INSERT INTO roles (name)
SELECT * FROM (SELECT 'admin' AS name) AS tmp
WHERE NOT EXISTS (SELECT 1 FROM roles WHERE name = 'admin');

-- Mapping table linking users to multiple roles
CREATE TABLE IF NOT EXISTS user_roles (
  user_id INT NOT NULL,
  role_id INT NOT NULL,
  PRIMARY KEY (user_id, role_id),
  CONSTRAINT fk_user_roles_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
  CONSTRAINT fk_user_roles_role FOREIGN KEY (role_id) REFERENCES roles(id) ON DELETE CASCADE
);

-- Mapping table linking classes to multiple teachers
CREATE TABLE IF NOT EXISTS class_teachers (
  class_id INT NOT NULL,
  user_id INT NOT NULL,
  PRIMARY KEY (class_id, user_id),
  CONSTRAINT fk_class_teachers_class FOREIGN KEY (class_id) REFERENCES classes(id) ON DELETE CASCADE,
  CONSTRAINT fk_class_teachers_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

-- Add a user_id column to the students table to link student accounts to user credentials
-- Only add if it does not already exist
ALTER TABLE students
  ADD COLUMN IF NOT EXISTS user_id INT UNIQUE,
  ADD CONSTRAINT fk_students_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL;