<?php
require_once __DIR__ . '/functions.php';

// Only teachers can access this page
if (!isLoggedIn()) {
    redirect('login.php');
}
$user = currentUser($pdo);

// We only allow teachers and admins to manage the library
if ($user['role'] !== 'teacher' && $user['role'] !== 'admin') {
    redirect('dashboard.php');
}

$error = '';
$success = '';

// Handle addition of a new OE
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_oe'])) {
    $ppsad = trim($_POST['ppsad'] ?? '');
    $name = trim($_POST['name'] ?? '');
    $desc = trim($_POST['description'] ?? '');
    $ecc = trim($_POST['ecc_type'] ?? '');
    $cp1 = trim($_POST['cp1'] ?? '');
    $cp2 = trim($_POST['cp2'] ?? '');
    $cp3 = trim($_POST['cp3'] ?? '');
    if (!$ppsad || !$name) {
        $error = "Les champs 'PPSAD' et 'Nom' sont obligatoires.";
    } else {
        $stmt = $pdo->prepare('INSERT INTO oe_library (ppsad, name, description, ecc_type, cp1, cp2, cp3) VALUES (?, ?, ?, ?, ?, ?, ?)');
        if ($stmt->execute([$ppsad, $name, $desc, $ecc, $cp1, $cp2, $cp3])) {
            $success = "Objet ajouté à la bibliothèque.";
        } else {
            $error = "Erreur lors de l'ajout de l'objet.";
        }
    }
}

// Handle deletion
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['delete_oe_id'])) {
    $delId = (int)$_POST['delete_oe_id'];
    $stmt = $pdo->prepare('DELETE FROM oe_library WHERE id = ?');
    $stmt->execute([$delId]);
    $success = "Objet supprimé de la bibliothèque.";
}

$oeList = getOELibrary($pdo);

$pageTitle = 'Bibliothèque des objets d\'enseignement';
include 'header.php';
?>

<h2>Bibliothèque des Objets d'enseignement (OE)</h2>

<?php if ($error): ?>
    <div class="message error"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>
<?php if ($success): ?>
    <div class="message success"><?php echo htmlspecialchars($success); ?></div>
<?php endif; ?>

<h3>Ajouter un nouvel objet</h3>
<form method="post" action="">
    <input type="hidden" name="add_oe" value="1">
    <label for="ppsad">PPSAD (Activité support)</label>
    <input type="text" id="ppsad" name="ppsad" required>

    <label for="name">Nom de l'objet (Objectif d'enseignement)</label>
    <input type="text" id="name" name="name" required>

    <label for="description">Description / justification</label>
    <textarea id="description" name="description"></textarea>

    <label for="ecc_type">Type d'ECC</label>
    <input type="text" id="ecc_type" name="ecc_type">

    <label for="cp1">Contenu prioritaire 1 (CP1)</label>
    <input type="text" id="cp1" name="cp1">

    <label for="cp2">Contenu prioritaire 2 (CP2)</label>
    <input type="text" id="cp2" name="cp2">

    <label for="cp3">Contenu prioritaire 3 (CP3)</label>
    <input type="text" id="cp3" name="cp3">

    <button type="submit">Ajouter à la bibliothèque</button>
</form>

<h3>Objets enregistrés</h3>
<?php if (empty($oeList)): ?>
    <p>Aucun objet n'est enregistré.</p>
<?php else: ?>
    <div class="table-container">
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>PPSAD</th>
                <th>Nom</th>
                <th>Description</th>
                <th>ECC</th>
                <th>CP1</th>
                <th>CP2</th>
                <th>CP3</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($oeList as $oe): ?>
            <tr>
                <td><?php echo $oe['id']; ?></td>
                <td><?php echo htmlspecialchars($oe['ppsad']); ?></td>
                <td><?php echo htmlspecialchars($oe['name']); ?></td>
                <td><?php echo nl2br(htmlspecialchars($oe['description'])); ?></td>
                <td><?php echo htmlspecialchars($oe['ecc_type']); ?></td>
                <td><?php echo htmlspecialchars($oe['cp1']); ?></td>
                <td><?php echo htmlspecialchars($oe['cp2']); ?></td>
                <td><?php echo htmlspecialchars($oe['cp3']); ?></td>
                <td>
                    <form method="post" action="" onsubmit="return confirmDelete('Supprimer cet objet ?');" style="display:inline">
                        <input type="hidden" name="delete_oe_id" value="<?php echo $oe['id']; ?>">
                        <button type="submit">Supprimer</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    </div>
<?php endif; ?>

<?php
include 'footer.php';
?>