<?php
require_once __DIR__ . '/functions.php';

// If user not logged in, redirect to login page
if (!isLoggedIn()) {
    redirect('login.php');
}

$user = currentUser($pdo);
$classes = getClasses($pdo, $user['id']);

$pageTitle = 'Tableau de bord';
include 'header.php';
?>

<h2>Bienvenue, <?php echo htmlspecialchars($user['name']); ?>!</h2>

<p>Utilisez ce tableau de bord pour gérer vos classes, cycles et leçons.</p>

<?php if (empty($classes)): ?>
    <p>Aucune classe n'a encore été créée. <a href="create_class.php">Ajoutez une première classe</a>.</p>
<?php else: ?>
    <h3>Vos classes</h3>
    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>Nom de la classe</th>
                    <th>Niveau</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($classes as $class): ?>
                <tr>
                    <td><?php echo htmlspecialchars($class['name']); ?></td>
                    <td><?php echo htmlspecialchars($class['level']); ?></td>
                    <td>
                        <a href="class_detail.php?id=<?php echo $class['id']; ?>">Voir</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>

<?php
include 'footer.php';
?>